#ifndef HOBBYKIT_H
#define HOBBYKIT_H

#define VERSION_HK "0.04"
#define WORD unsigned short
#define BYTE unsigned char
#define bit(x) (BYTE)1<<x

#define ON 1
#define OFF 0

#define print(x) SCI_OutString(x)
#define debug(x) print(#x); print(" "); SCI_OutUDec(x); print("\n");

#define DigitalInAll PTM
#define DigitalOutAll PORTT

//
// Initialize the NanoCore CPU
int NanoCore12Init(int config);

//******** Analog_In  ***************
// perform 10-bit analog to digital conversion
// input  : channel is 0 to 7 specifying which analog pin to sample
// output : measured voltage (float)
// errors : -1 if channel is not allowed
//
// analog input    ADC HEX value    ADC HEX value        return value
//  Volts          left justified   right justified      DECIMAL
//  0.000               0	               0              0.000
//  0.005            0040	               1              0.005
//  0.010            0080                  2              0.010
//  2.500            8000				 200              2.500
//  4.995            FF80                3FE              4.995
//  5.000            FFC0			     3FF              5.000
float AnalogIn(BYTE channel);
WORD AnalogInRaw(BYTE channel);

// ******** DigitalIn **************
// Input: the Digital channel on Port M to read
// Output: the value read from the channel
BYTE DigitalIn(BYTE channel);

// ******** DigitalOut ************
// Input: the digital channel on port T to write to and its new value
// Output: TBD
BYTE DigitalOut(BYTE channel, BYTE value);

// ********* wait ************
// wait interval milliseconds- quick hack   XXX
void wait(unsigned long interval);


// ******** pow *****************
// raise n to the exponent e
long pow (short n, short e);

// ********** PLL_Init  ***********
// Input: none
// Output: none
void PLL_Init(void);

#endif
