#ifndef  IOREGS12_H
#define  IOREGS12_H

#ifndef  IOREGS_BASE
#define  IOREGS_BASE    0x0000
#endif

#define _IO8(off)       *(unsigned char  volatile *)(IOREGS_BASE + off)
#define _IO16(off)      *(unsigned short volatile *)(IOREGS_BASE + off)

#define  PORTAB     _IO16(0x00)     // Port AB
#define  PORTA      _IO8(0x00)      //    - Port A
#define  PORTB      _IO8(0x01)      //    - Port B
#define  DDRAB      _IO16(0x02)     // Data Direction Register AB
#define  DDRA       _IO8(0x02)      //    - Data Direction Register A
#define  DDRB       _IO8(0x03)      //    - Data Directon Register B

#define  PORTE      _IO8(0x08)      /* i/o port e */
#define  DDRE       _IO8(0x09)      /* data direction reg e */
#define  PEAR       _IO8(0x0a)      // Port E Assignment Register
#define  MODE       _IO8(0x0b)      // Mode Register
#define  PUCR       _IO8(0x0c)      // Pull Up Control Register
#define  RDRIV      _IO8(0x0d)      //  Reduced Drive of I/O Lines
#define  EBICTL	    _IO8(0x0e)      // EXternal Bus Interface Control

#define  INITRM     _IO8(0x10)      // Init of Internal RAM Position Register
#define  INITRG     _IO8(0x11)      // Init of Internal Register Position Register
#define  INITEE     _IO8(0x12)      // initee */
#define  MISC       _IO8(0x13)      // Misc Mapping Control Register
#define  MTST0      _IO8(0x14)      /* mtst0 */
#define  ITCR       _IO8(0x15)      // Interrupt Test Control Register
#define  ITEST      _IO8(0x16)      // Interrupt Test Register
#define  MTST1      _IO8(0x17)      // mtst1 */
#define  VREGCTRL   _IO8(0x19)      // VREG_3V3 Control Register

#define  PARTIDH    _IO8(0x1a)      // Partition ID Register High
#define  PARTIDL    _IO8(0x1b)      // Partition ID Register Low
#define  MEMSIZ0    _IO8(0x1c)      // Memory Size Register Zero
#define  MEMSIZ1    _IO8(0x1d)      // Memory Size Register One

#define  INTCR      _IO8(0x1e)      // Interrupt Control Register
#define  HPRIO      _IO8(0x1f)      // Highest Priority I Interrupt

// Debug registers are skipped or malnamed    XXX

#define  BKPCT0     _IO8(0x28)
#define  BKPCT1     _IO8(0x29)
#define  BKP0X      _IO8(0x2a)
#define  BKP0H      _IO8(0x2b)
#define  BRP0l      _IO8(0x2c)
#define  BKP1X      _IO8(0x2d)
#define  BKP1H      _IO8(0x2e)
#define  BRP1L      _IO8(0x2f)

#define  PPAGE      _IO8(0x30)    // Page Index Register
#define  PORTK      _IO8(0x32)    // Port K
#define  DDRK       _IO8(0x33)    // Data Directoin Register Port K
#define  SYNR       _IO8(0x34)    // CRG Synthesizer Register
#define  REFDV      _IO8(0x35)    // CRG Reference Divider Register
#define  CTFLG      _IO8(0x36)
#define  CRGFLG     _IO8(0x37)    // CRG Flag Register
#define  CRGINT     _IO8(0x38)    //
#define  CLKSEL     _IO8(0x39)
#define  PLLCTL     _IO8(0x3a)
#define  RTICTL     _IO8(0x3b)
#define  COPCTL     _IO8(0x3c)
#define  FORBYP     _IO8(0x3d)
#define  CTCTL      _IO8(0x3e)
#define  ARMCOP     _IO8(0x3f)

#define  TIOS       _IO8(0x40)
#define  CFORC      _IO8(0x41)
#define  OC7M       _IO8(0x42)
#define  OC7D       _IO8(0x43)
#define  TCNT       _IO16(0x44)  // Timer Count Register
#define  TCNTH      _IO8(0x44)   //    - Timer Count Register High
#define  TCNTL      _IO8(0x45)   //    - Timer Count Register Low
#define  TSCR       _IO8(0x46)
#define  TTOV       _IO8(0x47)
#define  TCTL1      _IO8(0x48)
#define  TCTL2      _IO8(0x49)
#define  TCTL3      _IO8(0x4a)
#define  TCTL4      _IO8(0x4b)
#define  TMSK1      _IO8(0x4c)
#define  TMSK2      _IO8(0x4d)
#define  TFLG1      _IO8(0x4e)
#define  TFLG2      _IO8(0x4f)

// Timer
#define  TC0        _IO16(0x50)  // Timer Input Capture/Compare Register 0
#define  TC0H       _IO8(0x50)   //    -  Timer Input C/C Register 0 High
#define  TC0L       _IO8(0x51)   //    - Timer Input C/C Register 0 Low
#define  TC1        _IO16(0x52)  // Timer Input Capture/Compare Register 1
#define  TC1H       _IO8(0x52)   //    -  Timer Input C/C Register 1 High
#define  TC1L       _IO8(0x53)   //    - Timer Input C/C Register 1 Low
#define  TC2        _IO16(0x54)  // Timer Input Capture/Compare Register 2
#define  TC2H       _IO8(0x54)   //    -  Timer Input C/C Register 2 High
#define  TC2L       _IO8(0x55)   //    - Timer Input C/C Register 2 Low
#define  TC3        _IO16(0x56)  // Timer Input Capture/Compare Register 3
#define  TC3H       _IO8(0x50)   //    -  Timer Input C/C Register 3 High
#define  TC3L       _IO8(0x51)   //    - Timer Input C/C Register 3 Low
#define  TC4        _IO16(0x58)  // Timer Input Capture/Compare Register 4
#define  TC4H       _IO8(0x58)   //    -  Timer Input C/C Register 4 High
#define  TC4L       _IO8(0x59)   //    - Timer Input C/C Register 4 Low
#define  TC5        _IO16(0x5a)  // Timer Input Capture/Compare Register 5
#define  TC5H       _IO8(0x5a)   //    -  Timer Input C/C Register 5 High
#define  TC5L       _IO8(0x5b)   //    - Timer Input C/C Register 5 Low
#define  TC6        _IO16(0x5c)  // Timer Input Capture/Compare Register 6
#define  TC6H       _IO8(0x5c)   //    -  Timer Input C/C Register 6 High
#define  TC6L       _IO8(0x5d)   //    - Timer Input C/C Register 6 Low
#define  TC7        _IO16(0x5e)  // Timer Input Capture/Compare Register 7
#define  TC7H       _IO8(0x5e)   //    -  Timer Input C/C Register 7 High
#define  TC7L       _IO8(0x5f)   //    - Timer Input C/C Register 7 Low


#define  PACTL      _IO8(0x60)
#define  PAFLG      _IO8(0x61)
#define  PACNT      _IO8(0x62)   // Pulse Accumulator Count Register
#define  PACN2      _IO8(0x63)
#define  PACN1      _IO8(0x64)
#define  PACN0      _IO8(0x65)
#define  MCCTL      _IO8(0x66)
#define  MCFLG      _IO8(0x67)
#define  ICPAR      _IO8(0x68)
#define  DLYCT      _IO8(0x69)
#define  ICOVW      _IO8(0x6a)
#define  ICSYS      _IO8(0x6b)
#define  TIMTST     _IO8(0x6d)

// ATD registers    (analog to digital)
#define ATDCTL23    _IO16(0x82)       // ATD Control Register 23
#define ATDCTL2     _IO8(0x82)        //    - ATD Control Register 2
#define ATDCTL3     _IO8(0x83)        //    - ATD Control Register 3
#define ATDCTL45    _IO16(0x84)       // ATD Control REgister 45
#define ATDCTL4     _IO8(0x84)        //    - ATD Control Register 4
#define ATDCTL5     _IO8(0x85)        //    - ATD Control Register 5
#define ATDDR0      _IO16(0x90)       // A/D Conversion Result Register 0
#define ATDDR1      _IO16(0x92)       // A/D Conversion Result Register 1
#define ATDDR2      _IO16(0x94)       // A/D Conversion REsult Register 2
#define ATDDR3      _IO16(0x94)       // A/D Conversion REsult Register 3
#define ATDDR4      _IO16(0x94)       // A/D Conversion REsult Register 4
#define ATDDR5      _IO16(0x94)       // A/D Conversion REsult Register 5
#define ATDDR6      _IO16(0x9C)       // A/D Conversion REsult Register 6
#define ATDDR7      _IO16(0x9E)       // A/D Conversion REsult Register 7

// SCI registers    (serial port)
#define SCIBD       _IO16(0xC8)       // SCI Baud Rate register
#define SCIBDH      _IO8(0xC8)        //    - SCI Baud Rate register Low
#define SCIBDL      _IO8(0xC9)        //    - SCI Baud Rate register High
#define SCICR1      _IO8(0xCA)        // SCI control Register 1
#define SCICR2      _IO8(0xCB)        // SCI control Register 2
#define SCISR1      _IO8(0xCC)        // SCI Status Register 1
#define SCISR2      _IO8(0xCD)        // SCI Status Register 2
#define SCIDR       _IO16(0xCE)       // SCI Data Register
#define SCIDRH      _IO8(0xCE)        //    - SCI Data Register High
#define SCIDRL      _IO8(0xCF)        //    - SCI Data Register Low

// PWM
#define PWMCNT0     _IO8(0xEC)        // PWM Channel 0 Register
#define PWMCNT1     _IO8(0xED)        // PWM Channel 1 Register
#define PWMCNT2     _IO8(0xEE)        // PWM Channel 2 Register
#define PWMCNT3     _IO8(0xEF)        // PWM Channel 3 Register
#define PWMCNT4     _IO8(0xF0)        // PWM Channel 4 Register
#define PWMCNT5     _IO8(0xF1)        // PWM Channel 5 Register
#define PWMPER0     _IO8(0xF2)        // PWM Channel Period 0 Register
#define PWMPER1     _IO8(0xF3)        // PWM Channel Period 1 Register
#define PWMPER2     _IO8(0xF4)        // PWM Channel Period 2 Register
#define PWMPER3     _IO8(0xF5)        // PWM Channel Period 3 Register
#define PWMPER4     _IO8(0xF6)        // PWM Channel Period 4 Register
#define PWMPER5     _IO8(0xF7)        // PWM Channel Period 5 Register
#define PWMDTY0     _IO8(0xF8)        // PWM Channel Duty 0 Register
#define PWMDTY1     _IO8(0xF9)        // PWM Channel Duty 1 Register
#define PWMDTY2     _IO8(0xFA)        // PWM Channel Duty 2 Register
#define PWMDTY3     _IO8(0xFB)        // PWM Channel Duty 3 Register
#define PWMDTY4     _IO8(0xFC)        // PWM Channel Duty 4 Register
#define PWMDTY5     _IO8(0xFD)        // PWM Channel Duty 5 Register

// Port T
#define  PORTT      _IO8(0x240)      // Port T I/O Registers
#define  PTIT       _IO8(0x241)      // Port T input
#define  DDRT       _IO8(0x242)      // Data Direction Register Port T
#define  RDRT`      _IO8(0x243)      // Port T Reduced Drive Register
#define  PERT       _IO8(0x244)      // Port T Pull Device Enable Register
#define  PPST       _IO8(0x245)      // Port T Polarity Select Register

#define  PORTS      _IO8(0x248)      /* i/o port S */
#define  DDRS       _IO8(0x24a)      /* data direction reg S */

#define  PORTM      _IO8(0x250)      /* i/o port M */
#define  DDRM       _IO8(0x252)      /* data direction reg M */

#define  PORTP      _IO8(0x258)      /* i/o port P */
#define  DDRP       _IO8(0x25a)      /* data direction reg P */


//
// utilities
//
#define BIT0 0b00000001
#define BIT1 0b00000010
#define BIT2 0b00000100
#define BIT3 0b00001000
#define BIT4 0b00010000
#define BIT5 0b00100000
#define BIT6 0b01000000
#define BIT7 0b10000000


#endif
