#ifndef  _9s12c32_H
#define  _9s12c32_H

#ifndef  IOREGS_BASE
#define  IOREGS_BASE    0x0000
#endif

#define _IO8(off)       *(unsigned char  volatile *)(IOREGS_BASE + off)
#define _IO16(off)      *(unsigned short volatile *)(IOREGS_BASE + off)
#define  PORTAB        _IO16(0x0000)     // Port AB Register
#define  PORTA         _IO8(0x0000)      //   -- Port A Register
#define  PORTB         _IO8(0x0001)      //   -- Port B Register
#define  DDRAB         _IO16(0x0002)     // Port AB Data Direction Register
#define  DDRA          _IO8(0x0002)      //   -- Port A Data Direction Register
#define  DDRB          _IO8(0x0003)      //   -- Port B Data Direction Register
#define  PORTE         _IO8(0x0008)      // Port E Register
#define  DDRE          _IO8(0x0009)      // Port E Data Direction Register
#define  PEAR          _IO8(0x000A)      // Port E Assignment Register
#define  MODE          _IO8(0x000B)      // Mode Register
#define  PUCR          _IO8(0x000C)      // Pull-Up Control Register
#define  RDRIV         _IO8(0x000D)      // Reduced Drive of I/O Lines
#define  EBICTL        _IO8(0x000E)      // External Bus Interface Control
#define  INITRM        _IO8(0x0010)      // Initialization of Internal RAM Position Register
#define  INITRG        _IO8(0x0011)      // Initialization of Internal Register Position Register
#define  MISC          _IO8(0x0013)      // Miscellaneous Mapping Control Register
#define  MTST0         _IO8(0x0014)      // MTST0
#define  ITCR          _IO8(0x0015)      // Interrupt Test Control Register
#define  ITEST         _IO8(0x0016)      // Interrupt Test Register
#define  MTST1         _IO8(0x0017)      // MTST1
#define  VREGCTRL      _IO8(0x0019)      // VREG_3V3 - Control Register
#define  PARTIDH       _IO8(0x001A)      // Part ID Register High
#define  PARTIDL       _IO8(0x001B)      // Part ID Register Low
#define  MEMSIZ0       _IO8(0x001C)      // Memory Size Register 0
#define  MEMSIZ1       _IO8(0x001D)      // Memory Size Register 1
#define  INTCR         _IO8(0x001E)      // Interrupt Control Register
#define  HPRIO         _IO8(0x001F)      // Highest Priority I Interrupt
#define  DBGC1         _IO8(0x0020)      // Debug Control Register 1
#define  DBGSC         _IO8(0x0021)      // Debug Status and Control Register
#define  DBGTBHi       _IO8(0x0022)      // Debug Trace Buffer Register High
#define  DBGTBLo       _IO8(0x0023)      // Debug Trace Buffer Register Low
#define  DBGCNT        _IO8(0x0024)      // Debug Count Register
#define  DBGCCX        _IO8(0x0025)      // Debug Comparator C Extended Register
#define  DBGCCHi       _IO8(0x0026)      // Debug Comparator C Register High
#define  DBGCCLo       _IO8(0x0027)      // Debug Comparator C Register Low
#define  DBGC2         _IO8(0x0028)      // Debug Control Register 2
#define  DBGC3         _IO8(0x0029)      // Debug Control Register 3
#define  DBGCAX        _IO8(0x002A)      // Debug Comparator A Extended Register
#define  DBGCAHi       _IO8(0x002B)      // Debug Comparator A Register High
#define  DBGCALo       _IO8(0x002C)      // Debug Comparator A Register Low
#define  DBGCBX        _IO8(0x002D)      // Debug Comparator B Extended Register
#define  DBGCBHi       _IO8(0x002E)      // Debug Comparator B Register High
#define  DBGCBLo       _IO8(0x002F)      // Debug Comparator B Register Low
#define  PPAGE         _IO8(0x0030)      // Page Index Register
#define  PORTK         _IO8(0x0032)      // Port K Data Register
#define  DDRK          _IO8(0x0033)      // Port K Data Direction Register
#define  SYNR          _IO8(0x0034)      // CRG Synthesizer Register
#define  REFDV         _IO8(0x0035)      // CRG Reference Divider Register
#define  CRGFLG        _IO8(0x0037)      // CRG Flags Register
#define  CRGINT        _IO8(0x0038)      // CRG Interrupt Enable Register
#define  CLKSEL        _IO8(0x0039)      // CRG Clock Select Register
#define  PLLCTL        _IO8(0x003A)      // CRG PLL Control Register
#define  RTICTL        _IO8(0x003B)      // CRG RTI Control Register
#define  COPCTL        _IO8(0x003C)      // CRG COP Control Register
#define  ARMCOP        _IO8(0x003F)      // CRG COP Timer Arm/Reset Register
#define  TIOS          _IO8(0x0040)      // Timer Input Capture/Output Compare Select
#define  CFORC         _IO8(0x0041)      // Timer Compare Force Register
#define  OC7M          _IO8(0x0042)      // Output Compare 7 Mask Register
#define  OC7D          _IO8(0x0043)      // Output Compare 7 Data Register
#define  TCNT          _IO16(0x0044)     // Timer Count Register
#define  TCNTHi        _IO8(0x0044)      //   -- Timer Count Register High
#define  TCNTLo        _IO8(0x0045)      //   -- Timer Count Register Low
#define  TSCR1         _IO8(0x0046)      // Timer System Control Register1
#define  TTOV          _IO8(0x0047)      // Timer Toggle On Overflow Register
#define  TCTL1         _IO8(0x0048)      // Timer Control Register 1
#define  TCTL2         _IO8(0x0049)      // Timer Control Register 2
#define  TCTL3         _IO8(0x004A)      // Timer Control Register 3
#define  TCTL4         _IO8(0x004B)      // Timer Control Register 4
#define  TIE           _IO8(0x004C)      // Timer Interrupt Enable Register
#define  TSCR2         _IO8(0x004D)      // Timer System Control Register 2
#define  TFLG1         _IO8(0x004E)      // Main Timer Interrupt Flag 1
#define  TFLG2         _IO8(0x004F)      // Main Timer Interrupt Flag 2
#define  TC0           _IO16(0x0050)     // Timer Input Capture/Output Compare Register 0
#define  TC0Hi         _IO8(0x0050)      //   -- Timer Input Capture/Output Compare Register 0 High
#define  TC0Lo         _IO8(0x0051)      //   -- Timer Input Capture/Output Compare Register 0 Low
#define  TC1           _IO16(0x0052)     // Timer Input Capture/Output Compare Register 1
#define  TC1Hi         _IO8(0x0052)      //   -- Timer Input Capture/Output Compare Register 1 High
#define  TC1Lo         _IO8(0x0053)      //   -- Timer Input Capture/Output Compare Register 1 Low
#define  TC2           _IO16(0x0054)     // Timer Input Capture/Output Compare Register 2
#define  TC2Hi         _IO8(0x0054)      //   -- Timer Input Capture/Output Compare Register 2 High
#define  TC2Lo         _IO8(0x0055)      //   -- Timer Input Capture/Output Compare Register 2 Low
#define  TC3           _IO16(0x0056)     // Timer Input Capture/Output Compare Register 3
#define  TC3Hi         _IO8(0x0056)      //   -- Timer Input Capture/Output Compare Register 3 High
#define  TC3Lo         _IO8(0x0057)      //   -- Timer Input Capture/Output Compare Register 3 Low
#define  TC4           _IO16(0x0058)     // Timer Input Capture/Output Compare Register 4
#define  TC4Hi         _IO8(0x0058)      //   -- Timer Input Capture/Output Compare Register 4 High
#define  TC4Lo         _IO8(0x0059)      //   -- Timer Input Capture/Output Compare Register 4 Low
#define  TC5           _IO16(0x005A)     // Timer Input Capture/Output Compare Register 5
#define  TC5Hi         _IO8(0x005A)      //   -- Timer Input Capture/Output Compare Register 5 High
#define  TC5Lo         _IO8(0x005B)      //   -- Timer Input Capture/Output Compare Register 5 Low
#define  TC6           _IO16(0x005C)     // Timer Input Capture/Output Compare Register 6
#define  TC6Hi         _IO8(0x005C)      //   -- Timer Input Capture/Output Compare Register 6 High
#define  TC6Lo         _IO8(0x005D)      //   -- Timer Input Capture/Output Compare Register 6 Low
#define  TC7           _IO16(0x005E)     // Timer Input Capture/Output Compare Register 7
#define  TC7Hi         _IO8(0x005E)      //   -- Timer Input Capture/Output Compare Register 7 High
#define  TC7Lo         _IO8(0x005F)      //   -- Timer Input Capture/Output Compare Register 7 Low
#define  PACTL         _IO8(0x0060)      // 16-Bit Pulse Accumulator A Control Register
#define  PAFLG         _IO8(0x0061)      // Pulse Accumulator A Flag Register
#define  PACNT         _IO8(0x0062)      // Pulse Accumulators Count Register
#define  ATDCTL23      _IO16(0x0082)     // ATD Control Register 23
#define  ATDCTL2       _IO8(0x0082)      //   -- ATD Control Register 2
#define  ATDCTL3       _IO8(0x0083)      //   -- ATD Control Register 3
#define  ATDCTL45      _IO16(0x0084)     // ATD Control Register 45
#define  ATDCTL4       _IO8(0x0084)      //   -- ATD Control Register 4
#define  ATDCTL5       _IO8(0x0085)      //   -- ATD Control Register 5
#define  ATDSTAT0      _IO8(0x0086)      // A/D Status Register 0
#define  ATDSTAT1      _IO8(0x008B)      // A/D Status Register 1
#define  ATDDIEN       _IO8(0x008D)      // ATD Input Enable Mask Register
#define  PORTAD0       _IO8(0x008F)      // Port AD0 Register
#define  ATDDR0        _IO16(0x0090)     // A/D Conversion Result Register 0
#define  ATDDR0H       _IO8(0x0090)      //   -- A/D Conversion Result Register 0 High
#define  ATDDR0L       _IO8(0x0091)      //   -- A/D Conversion Result Register 0 Low
#define  ATDDR1        _IO16(0x0092)     // A/D Conversion Result Register 1
#define  ATDDR1H       _IO8(0x0092)      //   -- A/D Conversion Result Register 1 High
#define  ATDDR1L       _IO8(0x0093)      //   -- A/D Conversion Result Register 1 Low
#define  ATDDR2        _IO16(0x0094)     // A/D Conversion Result Register 2
#define  ATDDR2H       _IO8(0x0094)      //   -- A/D Conversion Result Register 2 High
#define  ATDDR2L       _IO8(0x0095)      //   -- A/D Conversion Result Register 2 Low
#define  ATDDR3        _IO16(0x0096)     // A/D Conversion Result Register 3
#define  ATDDR3H       _IO8(0x0096)      //   -- A/D Conversion Result Register 3 High
#define  ATDDR3L       _IO8(0x0097)      //   -- A/D Conversion Result Register 3 Low
#define  ATDDR4        _IO16(0x0098)     // A/D Conversion Result Register 4
#define  ATDDR4H       _IO8(0x0098)      //   -- A/D Conversion Result Register 4 High
#define  ATDDR4L       _IO8(0x0099)      //   -- A/D Conversion Result Register 4 Low
#define  ATDDR5        _IO16(0x009A)     // A/D Conversion Result Register 5
#define  ATDDR5H       _IO8(0x009A)      //   -- A/D Conversion Result Register 5 High
#define  ATDDR5L       _IO8(0x009B)      //   -- A/D Conversion Result Register 5 Low
#define  ATDDR6        _IO16(0x009C)     // A/D Conversion Result Register 6
#define  ATDDR6H       _IO8(0x009C)      //   -- A/D Conversion Result Register 6 High
#define  ATDDR6L       _IO8(0x009D)      //   -- A/D Conversion Result Register 6 Low
#define  ATDDR7        _IO16(0x009E)     // A/D Conversion Result Register 7
#define  ATDDR7H       _IO8(0x009E)      //   -- A/D Conversion Result Register 7 High
#define  ATDDR7L       _IO8(0x009F)      //   -- A/D Conversion Result Register 7 Low
#define  SCIBD         _IO16(0x00C8)     // SCI Baud Rate Register
#define  SCIBDH        _IO8(0x00C8)      //   -- SCI Baud Rate Register High
#define  SCIBDL        _IO8(0x00C9)      //   -- SCI Baud Rate Register Low
#define  SCICR1        _IO8(0x00CA)      // SCI Control Register 1
#define  SCICR2        _IO8(0x00CB)      // SCI Control Register 2
#define  SCISR1        _IO8(0x00CC)      // SCI Status Register 1
#define  SCISR2        _IO8(0x00CD)      // SCI Status Register 2
#define  SCIDRH        _IO8(0x00CE)      // SCI Data Register High
#define  SCIDRL        _IO8(0x00CF)      // SCI Data Register Low
#define  SPICR1        _IO8(0x00D8)      // SPI Control Register
#define  SPICR2        _IO8(0x00D9)      // SPI Control Register 2
#define  SPIBR         _IO8(0x00DA)      // SPI Baud Rate Register
#define  SPISR         _IO8(0x00DB)      // SPI Status Register
#define  SPIDR         _IO8(0x00DD)      // SPI Data Register
#define  PWME          _IO8(0x00E0)      // PWM Enable Register
#define  PWMPOL        _IO8(0x00E1)      // PWM Polarity Register
#define  PWMCLK        _IO8(0x00E2)      // PWM Clock Select Register
#define  PWMPRCLK      _IO8(0x00E3)      // PWM Prescale Clock Select Register
#define  PWMCAE        _IO8(0x00E4)      // PWM Center Align Enable Register
#define  PWMCTL        _IO8(0x00E5)      // PWM Control Register
#define  PWMSCLA       _IO8(0x00E8)      // PWM Scale A Register
#define  PWMSCLB       _IO8(0x00E9)      // PWM Scale B Register
#define  PWMCNT01      _IO16(0x00EC)     // PWM Channel Counter 01 Register
#define  PWMCNT0       _IO8(0x00EC)      //   -- PWM Channel Counter 0 Register
#define  PWMCNT1       _IO8(0x00ED)      //   -- PWM Channel Counter 1 Register
#define  PWMCNT23      _IO16(0x00EE)     // PWM Channel Counter 23 Register
#define  PWMCNT2       _IO8(0x00EE)      //   -- PWM Channel Counter 2 Register
#define  PWMCNT3       _IO8(0x00EF)      //   -- PWM Channel Counter 3 Register
#define  PWMCNT45      _IO16(0x00F0)     // PWM Channel Counter 45 Register
#define  PWMCNT4       _IO8(0x00F0)      //   -- PWM Channel Counter 4 Register
#define  PWMCNT5       _IO8(0x00F1)      //   -- PWM Channel Counter 5 Register
#define  PWMPER01      _IO16(0x00F2)     // PWM Channel Period 01 Register
#define  PWMPER0       _IO8(0x00F2)      //   -- PWM Channel Period 0 Register
#define  PWMPER1       _IO8(0x00F3)      //   -- PWM Channel Period 1 Register
#define  PWMPER23      _IO16(0x00F4)     // PWM Channel Period 23 Register
#define  PWMPER2       _IO8(0x00F4)      //   -- PWM Channel Period 2 Register
#define  PWMPER3       _IO8(0x00F5)      //   -- PWM Channel Period 3 Register
#define  PWMPER45      _IO16(0x00F6)     // PWM Channel Period 45 Register
#define  PWMPER4       _IO8(0x00F6)      //   -- PWM Channel Period 4 Register
#define  PWMPER5       _IO8(0x00F7)      //   -- PWM Channel Period 5 Register
#define  PWMDTY01      _IO16(0x00F8)     // PWM Channel Duty 01 Register
#define  PWMDTY0       _IO8(0x00F8)      //   -- PWM Channel Duty 0 Register
#define  PWMDTY1       _IO8(0x00F9)      //   -- PWM Channel Duty 1 Register
#define  PWMDTY23      _IO16(0x00FA)     // PWM Channel Duty 23 Register
#define  PWMDTY2       _IO8(0x00FA)      //   -- PWM Channel Duty 2 Register
#define  PWMDTY3       _IO8(0x00FB)      //   -- PWM Channel Duty 3 Register
#define  PWMDTY45      _IO16(0x00FC)     // PWM Channel Duty 45 Register
#define  PWMDTY4       _IO8(0x00FC)      //   -- PWM Channel Duty 4 Register
#define  PWMDTY5       _IO8(0x00FD)      //   -- PWM Channel Duty 5 Register
#define  PWMSDN        _IO8(0x00FE)      // PWM Shutdown Register
#define  FCLKDIV       _IO8(0x0100)      // Flash Clock Divider Register
#define  FSEC          _IO8(0x0101)      // Flash Security Register
#define  FCNFG         _IO8(0x0103)      // Flash Configuration Register
#define  FPROT         _IO8(0x0104)      // Flash Protection Register
#define  FSTAT         _IO8(0x0105)      // Flash Status Register
#define  FCMD          _IO8(0x0106)      // Flash Command Buffer and Register
#define  CANCTL0       _IO8(0x0140)      // MSCAN Control 0 Register
#define  CANCTL1       _IO8(0x0141)      // MSCAN Control 1 Register
#define  CANBTR0       _IO8(0x0142)      // MSCAN Bus Timing Register 0
#define  CANBTR1       _IO8(0x0143)      // MSCAN Bus Timing Register 1
#define  CANRFLG       _IO8(0x0144)      // MSCAN Receiver Flag Register
#define  CANRIER       _IO8(0x0145)      // MSCAN Receiver Interrupt Enable Register
#define  CANTFLG       _IO8(0x0146)      // MSCAN Transmitter Flag Register
#define  CANTIER       _IO8(0x0147)      // MSCAN Transmitter Interrupt Enable Register
#define  CANTARQ       _IO8(0x0148)      // MSCAN Transmitter Message Abort Request
#define  CANTAAK       _IO8(0x0149)      // MSCAN Transmitter Message Abort Control
#define  CANTBSEL      _IO8(0x014A)      // MSCAN Transmit Buffer Selection
#define  CANIDAC       _IO8(0x014B)      // MSCAN Identifier Acceptance Control Register
#define  CANRXERR      _IO8(0x014E)      // MSCAN Receive Error Counter Register
#define  CANTXERR      _IO8(0x014F)      // MSCAN Transmit Error Counter Register
#define  CANIDAR0      _IO8(0x0150)      // MSCAN Identifier Acceptance Register 0
#define  CANIDAR1      _IO8(0x0151)      // MSCAN Identifier Acceptance Register 1
#define  CANIDAR2      _IO8(0x0152)      // MSCAN Identifier Acceptance Register 2
#define  CANIDAR3      _IO8(0x0153)      // MSCAN Identifier Acceptance Register 3
#define  CANIDMR0      _IO8(0x0154)      // MSCAN Identifier Mask Register 0
#define  CANIDMR1      _IO8(0x0155)      // MSCAN Identifier Mask Register 1
#define  CANIDMR2      _IO8(0x0156)      // MSCAN Identifier Mask Register 2
#define  CANIDMR3      _IO8(0x0157)      // MSCAN Identifier Mask Register 3
#define  CANIDAR4      _IO8(0x0158)      // MSCAN Identifier Acceptance Register 4
#define  CANIDAR5      _IO8(0x0159)      // MSCAN Identifier Acceptance Register 5
#define  CANIDAR6      _IO8(0x015A)      // MSCAN Identifier Acceptance Register 6
#define  CANIDAR7      _IO8(0x015B)      // MSCAN Identifier Acceptance Register 7
#define  CANIDMR4      _IO8(0x015C)      // MSCAN Identifier Mask Register 4
#define  CANIDMR5      _IO8(0x015D)      // MSCAN Identifier Mask Register 5
#define  CANIDMR6      _IO8(0x015E)      // MSCAN Identifier Mask Register 6
#define  CANIDMR7      _IO8(0x015F)      // MSCAN Identifier Mask Register 7
#define  CANRXIDR0     _IO8(0x0160)      // MSCAN Receive Identifier Register 0
#define  CANRXIDR1     _IO8(0x0161)      // MSCAN Receive Identifier Register 1
#define  CANRXIDR2     _IO8(0x0162)      // MSCAN Receive Identifier Register 2
#define  CANRXIDR3     _IO8(0x0163)      // MSCAN Receive Identifier Register 3
#define  CANRXDSR0     _IO8(0x0164)      // MSCAN Receive Data Segment Register 0
#define  CANRXDSR1     _IO8(0x0165)      // MSCAN Receive Data Segment Register 1
#define  CANRXDSR2     _IO8(0x0166)      // MSCAN Receive Data Segment Register 2
#define  CANRXDSR3     _IO8(0x0167)      // MSCAN Receive Data Segment Register 3
#define  CANRXDSR4     _IO8(0x0168)      // MSCAN Receive Data Segment Register 4
#define  CANRXDSR5     _IO8(0x0169)      // MSCAN Receive Data Segment Register 5
#define  CANRXDSR6     _IO8(0x016A)      // MSCAN Receive Data Segment Register 6
#define  CANRXDSR7     _IO8(0x016B)      // MSCAN Receive Data Segment Register 7
#define  CANRXDLR      _IO8(0x016C)      // MSCAN Receive Data Length Register
#define  CANTXIDR0     _IO8(0x0170)      // MSCAN Transmit Identifier Register 0
#define  CANTXIDR1     _IO8(0x0171)      // MSCAN Transmit Identifier Register 1
#define  CANTXIDR2     _IO8(0x0172)      // MSCAN Transmit Identifier Register 2
#define  CANTXIDR3     _IO8(0x0173)      // MSCAN Transmit Identifier Register 3
#define  CANTXDSR0     _IO8(0x0174)      // MSCAN Transmit Data Segment Register 0
#define  CANTXDSR1     _IO8(0x0175)      // MSCAN Transmit Data Segment Register 1
#define  CANTXDSR2     _IO8(0x0176)      // MSCAN Transmit Data Segment Register 2
#define  CANTXDSR3     _IO8(0x0177)      // MSCAN Transmit Data Segment Register 3
#define  CANTXDSR4     _IO8(0x0178)      // MSCAN Transmit Data Segment Register 4
#define  CANTXDSR5     _IO8(0x0179)      // MSCAN Transmit Data Segment Register 5
#define  CANTXDSR6     _IO8(0x017A)      // MSCAN Transmit Data Segment Register 6
#define  CANTXDSR7     _IO8(0x017B)      // MSCAN Transmit Data Segment Register 7
#define  CANTXDLR      _IO8(0x017C)      // MSCAN Transmit Data Length Register
#define  CANTXTBPR     _IO8(0x017F)      // MSCAN Transmit Buffer Priority
#define  PORTT          _IO8(0x0240)      // Port T I/O Register
#define  PTIT          _IO8(0x0241)      // Port T Input
#define  DDRT          _IO8(0x0242)      // Port T Data Direction Register
#define  RDRT          _IO8(0x0243)      // Port T Reduced Drive Register
#define  PERT          _IO8(0x0244)      // Port T Pull Device Enable Register
#define  PPST          _IO8(0x0245)      // Port T Polarity Select Register
#define  MODRR         _IO8(0x0247)      // Port T Module Routing Register
#define  PTS           _IO8(0x0248)      // Port S I/O Register
#define  PTIS          _IO8(0x0249)      // Port S Input
#define  DDRS          _IO8(0x024A)      // Port S Data Direction Register
#define  RDRS          _IO8(0x024B)      // Port S Reduced Drive Register
#define  PERS          _IO8(0x024C)      // Port S Pull Device Enable Register
#define  PPSS          _IO8(0x024D)      // Port S Polarity Select Register
#define  WOMS          _IO8(0x024E)      // Port S Wired-Or Mode Register
#define  PTM           _IO8(0x0250)      // Port M I/O Register
#define  PTIM          _IO8(0x0251)      // Port M Input
#define  DDRM          _IO8(0x0252)      // Port M Data Direction Register
#define  RDRM          _IO8(0x0253)      // Port M Reduced Drive Register
#define  PERM          _IO8(0x0254)      // Port M Pull Device Enable Register
#define  PPSM          _IO8(0x0255)      // Port M Polarity Select Register
#define  WOMM          _IO8(0x0256)      // Port M Wired-Or Mode Register
#define  PTP           _IO8(0x0258)      // Port P I/O Register
#define  PTIP          _IO8(0x0259)      // Port P Input
#define  DDRP          _IO8(0x025A)      // Port P Data Direction Register
#define  RDRP          _IO8(0x025B)      // Port P Reduced Drive Register
#define  PERP          _IO8(0x025C)      // Port P Pull Device Enable Register
#define  PPSP          _IO8(0x025D)      // Port P Polarity Select Register
#define  PIEP          _IO8(0x025E)      // Port P Interrupt Enable Register
#define  PIFP          _IO8(0x025F)      // Port P Interrupt Flag Register
#define  PTJ           _IO8(0x0268)      // Port J I/O Register
#define  PTIJ          _IO8(0x0269)      // Port J Input Register
#define  DDRJ          _IO8(0x026A)      // Port J Data Direction Register
#define  RDRJ          _IO8(0x026B)      // Port J Reduced Drive Register
#define  PERJ          _IO8(0x026C)      // Port J Pull Device Enable Register
#define  PPSJ          _IO8(0x026D)      // Port JP Polarity Select Register
#define  PIEJ          _IO8(0x026E)      // Port J Interrupt Enable Register
#define  PIFJ          _IO8(0x026F)      // Port J Interrupt Flag Register
#define  PTAD          _IO8(0x0270)      // Port AD I/O Register
#define  PTIAD         _IO8(0x0271)      // Port AD Input Register
#define  DDRAD         _IO8(0x0272)      // Port AD Data Direction Register
#define  RDRAD         _IO8(0x0273)      // Port AD Reduced Drive Register
#define  PERAD         _IO8(0x0274)      // Port AD Pull Device Enable Register
#define  PPSAD         _IO8(0x0275)      // Port AD Polarity Select Register


// Interrupt locations
extern _vectors_addr;
#define VECTORBASE         _vectors_addr
#define VECTOR16(off)      (VECTORBASE + off)

#define RTI_VECTOR         VECTOR16(0xf0)
#define ISR_T0C3          *(void(**)())VECTOR16(0xe8)
#endif
